/*****************************************************************************
 *
 * stir42xx.c - USB 2.0 IrDA Bridge Control Program
 *
 *  Copyright (C) 2004, SigmaTel, Inc. <irquality@sigmatel.com>
 *          
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place Ste 330, Boston MA 02111, USA
 *
 *
 * MODIFICATION HISTORY
 *
 *   DATE     WHO/WHAT
 *
 * 2004-07-29 SigmaTel, Inc.
 *            Modified to support SigmaTel STIR42xx
 *
 ******************************************************************************/

#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <linux/types.h>
#include "stir42xxi.h"


void validate_return_code(const int rc, const char *strmsg, const char *strfn)
{
    if (rc < 0)
    {
        if (!opt_quiet)
        {
            char *str_error ;
            if (errno != 0)
            {
                str_error = strerror(errno) ;
            }
            else
            {
                str_error = "internal error" ;
            }
            fprintf(stderr, "%s(): %s: %s (%d)\n",
		strfn,
		strmsg,
		str_error,
		errno
		) ;
        }
        exit(1) ;
    }
}



int main(int argc, char* argv[])
{
    int fdNetwork ;
    struct ifreq ifreq ;
    ssize_t patchsize ;

    // get command line arguments
    getargs(argc, argv) ;

    // gain access to a network socket
    if (opt_verbose) printf("Opening socket ... ") ;
    fflush(stdout) ;
    fdNetwork = socket(AF_LOCAL,SOCK_DGRAM,0) ;
    validate_return_code(fdNetwork,"cannot open socket",__FUNCTION__ ) ;
    if (opt_verbose) printf("ok\n") ;

    memset(&ifreq,'\0',sizeof(struct ifreq)) ;

    if (opt_patchfile)
    {
        char *patchfile = NULL ;
        // open the patchfile
        int fdPatchfile ;
        struct stat stat ;
        if (opt_verbose) printf("Opening %s ... ",opt_patchfile) ;
        fflush(stdout) ;
        fdPatchfile = open(opt_patchfile,O_RDONLY) ;
        validate_return_code(fdPatchfile,"cannot open patchfile",__FUNCTION__ ) ;
        if (opt_verbose) printf("ok\n") ;

        if (opt_verbose) printf("Getting length of %s ... ",opt_patchfile) ;
        fflush(stdout) ;
        validate_return_code(fstat(fdPatchfile,&stat),"cannot stat patchfile",__FUNCTION__ ) ;
        if (stat.st_size <= PATCH_FILE_SIZE_MAX)
        {
            if (opt_verbose) printf("ok (%u bytes)\n",stat.st_size) ;
        }
        else
        {
            fprintf(stderr, "patchfile too large\n",__FUNCTION__ ) ;
            exit(1) ;
            NEVER_GETS_HERE() ;
        }

        // allocate the patchfile buffer
        if (opt_verbose) printf("Allocating patchfile buffer ... ") ;
        fflush(stdout) ;
        patchfile = (char *) malloc(sizeof(size_t) + stat.st_size) ;
        if (patchfile == NULL)
        {
            validate_return_code(-1,"cannot malloc patchfile buffer",__FUNCTION__ ) ;
            NEVER_GETS_HERE() ;
        }
        if (opt_verbose) printf("ok\n") ;

        // read the patchfile all at once
        if (opt_verbose) printf("Reading patch data ... ") ;
        fflush(stdout) ;
        patchsize = read(
	    fdPatchfile,
            &patchfile[sizeof(size_t)],
            stat.st_size
            ) ;
        validate_return_code(patchsize,"cannot read patch file",__FUNCTION__ ) ;
        if (patchsize != stat.st_size)
        {
            fprintf(stderr,"unexpected return value from patchfile read\n",__FUNCTION__ ) ;
            exit(1) ;
            NEVER_GETS_HERE() ;
        }
        if (opt_verbose) printf("ok\n") ;
    	ifreq.ifr_data = patchfile ;
        *((size_t *)patchfile) = patchsize ;
    }
    else
    {
    	ifreq.ifr_data = NULL ;
    }

    strcpy(ifreq.ifr_name,opt_ifname) ;
    if (opt_verbose) printf("Issuing ioctl to device (driver) ... ") ;
    fflush(stdout) ;
    validate_return_code(ioctl(fdNetwork,SIOCDEVPATCH42XX,&ifreq),"ioctl failed",__FUNCTION__ ) ;
    if (opt_verbose) printf("ok\n") ;

    return 0 ;

}
