/*****************************************************************************
 *
 * getargs.c - USB 2.0 IrDA Bridge Control Program
 *             Command Line Argument Parser
 *
 *  Copyright (C) 2004, SigmaTel, Inc. <irquality@sigmatel.com>
 *          
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place Ste 330, Boston MA 02111, USA
 *
 *
 * MODIFICATION HISTORY
 *
 *   DATE     WHO/WHAT
 *
 * 2004-07-29 SigmaTel, Inc.
 *            Modified to support SigmaTel STIR42xx
 *
 ******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <getopt.h>
#include <sys/socket.h>
#include <unistd.h>
#include <net/if.h>

#include "stir42xxi.h"

char *  myname
            = NULL ;
int     opt_quiet
            = 0 ;
int     opt_verbose
            = 0 ;
char *  opt_patchfile
            = NULL ;
char *  opt_ifname
            = NULL ;

struct option long_options[] =
{
    { "quiet",      no_argument,        NULL,       'q' },
    { "verbose",    no_argument,        NULL,       'v' },
    { "patchfile",  required_argument,  NULL,       'p' },
    { "help",       no_argument,        NULL,       '?' },
    { NULL,         0,                  NULL,        0  },
};


void usage(void)
{
    if (!opt_quiet)
    {
        fprintf(
            stderr,
            "usage:\n\t%s [{-q | --quiet} | {-v | --verbose}] [-p patchfile | --patchfile=patchfile ] ifname\n",
                myname
            ) ;
    }
    exit(2) ;
    NEVER_GETS_HERE() ;
}



void getargs(int argc, char* argv[])
{
    int ch ;

    // get my program name for usage()
    myname = argv[0] ;

    while ((ch = getopt_long(argc, argv, "qvp:", long_options, NULL)) >= 0)
    {
        switch(ch)
        {
            case 'q':
                opt_quiet++ ;
                break ;
            case 'v':
                opt_verbose++ ;
                break ;
            case 'p':
                if (opt_patchfile)
                {
                    usage() ;
                    NEVER_GETS_HERE() ;
                }

                opt_patchfile = optarg ;
                break ;
            case '?':
                opt_quiet = 0 ;
            default:
                {
                    usage() ;
                    NEVER_GETS_HERE() ;
                }
        }
    }

    if (opt_quiet && opt_verbose)
    {
        fprintf(stderr,"can't be both quiet and verbose\n") ;
        exit(2) ;
        NEVER_GETS_HERE() ;
    }

    // get ifname
    if (argc <= optind)
    {
        usage() ;
        NEVER_GETS_HERE() ;
    }
    opt_ifname = argv[optind] ;
    optind++ ;

    // make sure no args remain
    if (argc > optind)
    {
        usage() ;
        NEVER_GETS_HERE() ;
    }

    if (strlen(opt_ifname) > (IFNAMSIZ-1))
    {
        fprintf(stderr, "ifname too long\n") ;
        exit(2) ;
        NEVER_GETS_HERE() ;
    }

}
